#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	


	[TestFixture]
	public class BOL_TransfusionReactionType : BaseTest
	{
		BOL.TransfusionReactionType _trxType;
		DataRow _drType = null;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			//
			if (this.RefreshData)
			{
				_trxType = new BOL.TransfusionReactionType(BOL.TransfusionReactionType.GetTransfusionReactionTypeCharFromEnum(Common.TransfusionReactionType.FebrileNonHemolytic));
				this.RefreshData = false;
			}
			//
			_drType = UnitTestUtil.RunSQLGetDataRow("SELECT * FROM dbo.TransfusionReactionType WHERE TransfusionReactionTypeCode = '"+
				BOL.TransfusionReactionType.GetTransfusionReactionTypeCharFromEnum(Common.TransfusionReactionType.FebrileNonHemolytic)+"'");
		}


		[Test]
		public void Ctor_Pass()
		{
			BOL.TransfusionReactionType trx = new BOL.TransfusionReactionType(BOL.TransfusionReactionType.GetTransfusionReactionTypeCharFromEnum(Common.TransfusionReactionType.FebrileNonHemolytic));
			Assert.AreEqual(_trxType.TransfusionReactionTypeCode,trx.TransfusionReactionTypeCode,"TransfusionReactionTypeCode");
			Assert.AreEqual(_trxType.TransfusionReactionTypeText,trx.TransfusionReactionTypeText,"TransfusionReactionTypeText");
			Assert.AreEqual(_trxType.SortColumn,trx.SortColumn,"SortColumn");
		}

		[Test]
        [ExpectedException(typeof(Common.DataAccessLayerException))]
		public void Ctor_Fail()
		{
			BOL.TransfusionReactionType trx = new BOL.TransfusionReactionType('!');
			Assert.AreEqual(_trxType.TransfusionReactionTypeCode,trx.TransfusionReactionTypeCode,"TransfusionReactionTypeCode");
			Assert.AreEqual(_trxType.TransfusionReactionTypeText,trx.TransfusionReactionTypeText,"TransfusionReactionTypeText");
			Assert.AreEqual(_trxType.SortColumn,trx.SortColumn,"SortColumn");
		}

		[Test]
		public void TransfusionReactionTypeCode_Pass()
		{
			Assert.AreEqual(BOL.TransfusionReactionType.GetTransfusionReactionTypeEnum(Convert.ToChar(this._drType[TABLES.TransfusionReactionType.TransfusionReactionTypeCode])),this._trxType.TransfusionReactionTypeCode,"TransfusionReactionTypeCode");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TransfusionReactionTypeCode_Fail()
		{
		}

		[Test]
		public void TransfusionReactionTypeText_Pass()
		{
			Assert.AreEqual(this._drType[TABLES.TransfusionReactionType.TransfusionReactionTypeText].ToString(),this._trxType.TransfusionReactionTypeText,"TransfusionReactionTypeText");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TransfusionReactionTypeText_Fail()
		{
		}

		[Test]
		public void SortColumn_Pass()
		{
			Assert.AreEqual(Convert.ToInt16(this._drType[TABLES.TransfusionReactionType.SortColumn]),this._trxType.SortColumn,"SortColumn");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SortColumn_Fail()
		{
		}

		[Test]
		public void LastUpdateDate_Pass()
		{
			Assert.AreEqual(this._drType[TABLES.TransfusionReactionType.LastUpdateDate].ToString(),this._trxType.LastUpdateDate.ToString(),"LastUpdateDate");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LastUpdateDate_Fail()
		{
		}

		[Test]
		public void LastUpdateUser_Pass()
		{
			Assert.AreEqual(this._drType[TABLES.TransfusionReactionType.LastUpdateUser].ToString(),this._trxType.LastUpdateUser,"LastUpdateUser");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LastUpdateUser_Fail()
		{
		}

		[Test]
		public void RowVersion_Pass()
		{
			Assert.AreEqual(this._drType[TABLES.TransfusionReactionType.RowVersion].ToString(),this._trxType.RowVersion.ToString(),"RowVersion");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void RowVersion_Fail()
		{
		}

		[Test]
		public void GetTransfusionReactionType_Pass()
		{
			BOL.TransfusionReactionType trx = BOL.TransfusionReactionType.GetTransfusionReactionType(BOL.TransfusionReactionType.GetTransfusionReactionTypeCharFromEnum(Common.TransfusionReactionType.FebrileNonHemolytic));
			Assert.AreEqual(_trxType.TransfusionReactionTypeCode,trx.TransfusionReactionTypeCode,"TransfusionReactionTypeCode");
			Assert.AreEqual(_trxType.TransfusionReactionTypeText,trx.TransfusionReactionTypeText,"TransfusionReactionTypeText");
			Assert.AreEqual(_trxType.SortColumn,trx.SortColumn,"SortColumn");
		}

		[Test]
		[ExpectedException(typeof(Common.DataAccessLayerException))]
		public void GetTransfusionReactionType_Fail()
		{
			BOL.TransfusionReactionType trx = BOL.TransfusionReactionType.GetTransfusionReactionType('!');
			Assert.AreEqual(_trxType.TransfusionReactionTypeCode,trx.TransfusionReactionTypeCode,"TransfusionReactionTypeCode");
			Assert.AreEqual(_trxType.TransfusionReactionTypeText,trx.TransfusionReactionTypeText,"TransfusionReactionTypeText");
			Assert.AreEqual(_trxType.SortColumn,trx.SortColumn,"SortColumn");
		}

		[Test]
		public void GetTransfusionReactionTypeEnum_Pass()
		{
			Assert.AreEqual(Common.TransfusionReactionType.Circulatory,BOL.TransfusionReactionType.GetTransfusionReactionTypeEnum('C'),"Circulatory");
		}

		[Test]
		public void GetTransfusionReactionTypeEnum_Fail()
		{
			Assert.AreEqual(Common.TransfusionReactionType.Unknown,BOL.TransfusionReactionType.GetTransfusionReactionTypeEnum('!'),"InvalidReactionType");
		}

		[Test]
		public void GetTransfusionReactionTypeCharFromEnum_Pass()
		{
			Assert.AreEqual('G',BOL.TransfusionReactionType.GetTransfusionReactionTypeCharFromEnum(Common.TransfusionReactionType.GraftVsHostDisease),"GraftVsHostDisease");
		}

		[Test]
		public void GetTransfusionReactionTypeCharFromEnum_Fail()
		{
			Assert.AreEqual(char.MinValue,BOL.TransfusionReactionType.GetTransfusionReactionTypeCharFromEnum(Common.TransfusionReactionType.Unknown),"GraftVsHostDisease");
		}
	}
}
#endif
